# DX_CC6_CORE_HOST_SIDE makefile
# WMDRM component
#

COMP_NAME := $(WMDRM_ID)

#id's of the components this component depends on
$(COMP_NAME)_DEPEND_ON_APIS := $(SST_ID) $(CRYS_ID) $(VOS_ID) $(CC6_GEN_ID) $(KMNG_ID)

#paths of this component API include directories
$(COMP_NAME)_API_INCL_PATH := \
	$(HOST_PATH)WMDRM/Source/inc/ 

#paths of the internal include directories
$(COMP_NAME)_INTERNAL_INCL_PATH := \
	$(HOST_PATH)WMDRM/Source/core/ \
	$(HOST_PATH)WMDRM/Source/crypto/bignum/ \
	$(HOST_PATH)WMDRM/Source/crypto/drmcrypto/ \
	$(HOST_PATH)WMDRM/Source/oem/ansi/rsa/

#global flags for this component
#project-specific flags for this component should be added to $($(COMP_NAME)_SPECIFIC_CCFLAGS) outside of this makefile
$(COMP_NAME)_CCFLAGS := 

#the objects names without path or extension
$(COMP_NAME)_OBJ_NAMES := \
	blackbox_host cmdlnpars drmbase64 \
	drmbytemanip drmcbc drmchain drmcipher \
	drmcleanstore drmconstants drmcrt drmdebug \
	drmdevicestore drmexpreval drmexprfunc drmexprvariable \
	drmhdrbuilder drmhdrparser drmhds drmhds_impl \
	drmhmac drmint64 drmkeygen drmlicacqreq \
	drmlicacqresp drmliceval drmlicparser drmlicstore \
	drmmd5 drmoutputlevels drmprofile drmrevocation \
	drmrsaex drmsecstore drmsha1 drmstkalloc \
	drmutilities drmviewrights drmxmlbuilder drmxmlparser \
	drmxmlutilities tipatch \
	deskey_host rc4 pkcrypto_host \
	pkcrypto devcert devicedevcert drmmanager \
	drmmetering drmmgrmeter oemcriticalsection oemfileio \
	oemimpl oeminfo \
	oemtime DrmRsa rsaimpl secureclockrequest \
	secureclockresponse drmgensyncchallenge drmsyncstore drmcertparser

#Use the above specific settings for building the components properties with the standard rules:
include $(MF_PATH)CC6_STD_RULES.inc

##  OBJECT RULES - ADD RULES FOR NEW SOURCE FILES
#   make sure to add obj_name to the above list: $(COMP_NAME)_OBJS
#   this is the template for rules:
#$(OUT_OBJ_PATH)<<OBJ_NAME>>.$(OBJEXT): $(HOST_PATH)<<SOURCE_PATH>>
#	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@


$(OUT_OBJ_PATH)blackbox_host.$(OBJEXT): $(HOST_PATH)WMDRM/Source/blackbox/blackbox_host.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)cmdlnpars.$(OBJEXT): $(HOST_PATH)WMDRM/Source/cmdlnpars/cmdlnpars.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmbase64.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmbase64.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmbytemanip.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmbytemanip.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmcbc.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmcbc.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmchain.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmchain.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmcipher.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmcipher.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmcleanstore.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmcleanstore.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmconstants.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmconstants.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmcrt.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmcrt.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmdebug.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmdebug.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmdevicestore.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmdevicestore.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmexpreval.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmexpreval.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmexprfunc.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmexprfunc.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmexprvariable.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmexprvariable.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmhdrbuilder.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmhdrbuilder.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmhdrparser.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmhdrparser.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmhds.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmhds.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmhds_impl.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmhds_impl.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmhmac.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmhmac.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmint64.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmint64.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmkeygen.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmkeygen.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmlicacqreq.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmlicacqreq.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmlicacqresp.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmlicacqresp.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmliceval.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmliceval.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmlicparser.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmlicparser.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmlicstore.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmlicstore.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmmd5.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmmd5.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmoutputlevels.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmoutputlevels.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmprofile.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmprofile.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmrevocation.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmrevocation.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmrsaex.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmrsaex.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmsecstore.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmsecstore.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmsha1.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmsha1.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmstkalloc.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmstkalloc.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmutilities.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmutilities.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmviewrights.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmviewrights.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmxmlbuilder.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmxmlbuilder.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmxmlparser.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmxmlparser.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmxmlutilities.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/drmxmlutilities.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)tipatch.$(OBJEXT): $(HOST_PATH)WMDRM/Source/core/tipatch.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)deskey_host.$(OBJEXT): $(HOST_PATH)WMDRM/Source/crypto/drmcrypto/deskey_host.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)rc4.$(OBJEXT): $(HOST_PATH)WMDRM/Source/crypto/drmcrypto/rc4.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)pkcrypto.$(OBJEXT): $(HOST_PATH)WMDRM/Source/crypto/pkcrypto/pkcrypto.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)pkcrypto_host.$(OBJEXT): $(HOST_PATH)WMDRM/Source/crypto/pkcrypto/pkcrypto_host.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)devcert.$(OBJEXT): $(HOST_PATH)WMDRM/Source/devcertparser/devcert.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)devicedevcert.$(OBJEXT): $(HOST_PATH)WMDRM/Source/devicedevcert/devicedevcert.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmmanager.$(OBJEXT): $(HOST_PATH)WMDRM/Source/drmmanager/drmmanager.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmmetering.$(OBJEXT): $(HOST_PATH)WMDRM/Source/metering/drmmetering.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmmgrmeter.$(OBJEXT): $(HOST_PATH)WMDRM/Source/metering/drmmgrmeter.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)oemcriticalsection.$(OBJEXT): $(HOST_PATH)WMDRM/Source/oem/ansi/oemcriticalsection.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)oemfileio.$(OBJEXT): $(HOST_PATH)WMDRM/Source/oem/ansi/oemfileio.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)oemimpl.$(OBJEXT): $(HOST_PATH)WMDRM/Source/oem/ansi/oemimpl.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)oeminfo.$(OBJEXT): $(HOST_PATH)WMDRM/Source/oem/ansi/oeminfo.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)oemtime.$(OBJEXT): $(HOST_PATH)WMDRM/Source/oem/ansi/oemtime.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)DrmRsa.$(OBJEXT): $(HOST_PATH)WMDRM/Source/oem/ansi/rsa/DrmRsa.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)rsaimpl.$(OBJEXT): $(HOST_PATH)WMDRM/Source/oem/ansi/rsa/rsaimpl.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)secureclockrequest.$(OBJEXT): $(HOST_PATH)WMDRM/Source/secure_clock/secureclockrequest.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)secureclockresponse.$(OBJEXT): $(HOST_PATH)WMDRM/Source/secure_clock/secureclockresponse.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmgensyncchallenge.$(OBJEXT): $(HOST_PATH)WMDRM/Source/synclist/drmgensyncchallenge.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmsyncstore.$(OBJEXT): $(HOST_PATH)WMDRM/Source/synclist/drmsyncstore.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)drmcertparser.$(OBJEXT): $(HOST_PATH)WMDRM/Source/wmdrmcert/certparser/drmcertparser.c
	$(WMDRM_CC_CMD) $< $(CCFLAG_OUTPUT) $@

